/* aspect ratio: forces an aspect ratio. Heavily abridged from
   jquery.flot.coordinate.js (other change: now preserve y_center)...
   the info for that follows:
   

Flot plugin that adds some extra coordinate axes to flot chart.

Copyright (c) 2013 http://zizhujy.com.
Licensed under the MIT license.

Usage:
    Inside the <head></head> area of your html page, add the following lines:
    
    <script type="text/javascript" src="http://zizhujy.com/Scripts/flot/jquery.flot.coordinate.js"></script>

    Now you are all set. This plugin will draw a default coordinate axes for you.

Online examples:
    http://zizhujy.com/Plotter is using it, you can take a look to get the first impression about what this plugin can do.

Dependencies:
    jquery.js
    jquery.flot.js

Customizations:
    The coordinate type are accessed as strings separated by pipe line '|' through the coordinate option:

    options{
        coordinate: {
            type: 'rectangular|default'
        }
    }
*/

(function ($) {
    var classes = null;
    var surface = null;

    function processCoordinates(plot, canvascontext) {
        var options = plot.getOptions();

        var $flotText = $(".flot-text");
        $flotText.hide();
        surface = new classes.Canvas("flot-base", plot.getPlaceholder());
        handleRatioXY(plot);
        $(".flot-text").show();
    }

    function handleRatioXY(plot) {
        // Handle axes ratio
        var options = plot.getOptions();
        var axes = plot.getAxes();
        var xaxis = axes.xaxis;
        var yaxis = axes.yaxis;
        console.log('handleratioxy', options);
        if (options.aspectratio.ratioXY) {
            $.extend(true, xaxis.options, { min: xaxis.min, max: xaxis.max });
            $.extend(true, yaxis.options, { min: yaxis.min, max: yaxis.max });

            var ratio = parseFloat(options.aspectratio.ratioXY);
            // deltaX / deltaY = ratioXY * width / height
            xaxis.options = xaxis.options || {};
            if (!xaxis.options.max) xaxis.options.max = 10;
            if (!xaxis.options.min) xaxis.options.min = -10;
            var deltaX = xaxis.options.max - xaxis.options.min;
            var deltaY = deltaX / (ratio * plot.width() / plot.height());

            yaxis.options = yaxis.options || {};
            if (!yaxis.options.max) yaxis.options.max = 10;
            if (!yaxis.options.min) yaxis.options.min = -10;
            var r = (yaxis.options.max - yaxis.options.min) / deltaY;
            
            var y_center = (yaxis.options.max + yaxis.options.min) / 2.;
//console.log('old max:', yaxis.options.max);
//console.log('old min:', yaxis.options.min);
//console.log('r:', r);
            // Adjust y-axis based on the ratio and x-axis
            yaxis.options.max = yaxis.options.max / r;
            yaxis.options.min = yaxis.options.min / r;
            
            // recenter the y-axis
            var y_shift = (yaxis.options.max + yaxis.options.min) / 2. - y_center;
            yaxis.options.max -= y_shift;
            yaxis.options.min -= y_shift;

            $.extend(true, options, { xaxis: { options: { min: xaxis.options.min, max: xaxis.options.max } }, yaxis: { options: { min: yaxis.options.min, max: yaxis.options.max } } });
            plot.setupGrid();
            //alert("coor " + xaxis.options.min);
        }
    }


    function init(plot, theClasses) {
        classes = theClasses;
        plot.hooks.drawBackground.push(processCoordinates);
        plot.hooks.bindEvents.push(function () {
            var options = plot.getOptions();
            $(".flot-text").filter(function () { return $(this).text() === ""; }).remove();
        });
    }

    var options = {
        aspectratio: { type: 'default' }
    };

    $.plot.plugins.push({
        init: init,
        options: options,
        name: 'aspectratio',
        version: '0.1'
    });
})(jQuery);
