from neuron import h
from load_swc import load_swc

h.load_file('stdlib.hoc')
h.load_file('stdrun.hoc')

class Cell:
    def __str__(self):
        return 'neuron'

cell = Cell()
load_swc('04a_pyramidal4aACC.swc', cell)

for sec in cell.all:
    sec.nseg = 1 + 2 * int(sec.L / 30.)

for sec in cell.soma + cell.axon:
    sec.insert('hh')

for sec in cell.dend + cell.apic:
    sec.insert('pas')
    for seg in sec:
        seg.pas.g = 0.0001

iclamp = h.IClamp(0.5, sec=cell.soma[0])

v = h.Vector()
v.record(cell.soma[0](0.5)._ref_v)
t = h.Vector()
t.record(h._ref_t)

h.finitialize(-68)

soma = cell.soma[0](0.5)
settings = {'tstop': 50, 'ion': 10, 'idur': 20, 'iamp': 0.7, 'gna': soma.hh.gnabar, 'gk': soma.hh.gkbar, 'gl': soma.hh.gl}
default_settings = dict(settings)

def apply_settings():
    """apply the settings to the NEURON model"""
    h.tstop = settings['tstop']
    iclamp.amp = settings['iamp']
    iclamp.delay = settings['ion']
    iclamp.dur = settings['idur']
    for sec in cell.soma + cell.axon:
        for seg in sec:
            seg.hh.gna = settings['gna']
            seg.hh.gk = settings['gk']
            seg.hh.gl = settings['gl']
