import json
from neuron import h
from PyNeuronToolbox import morphology
from matplotlib import pyplot

h.load_file('stdrun.hoc')

num_cells = 20

class Pyramidal:
    def __init__(self, gid):
        self._gid = gid
        self._setup_morphology()
        self._discretize()
        self._add_channels()
        self._register_netcon()
    def _register_netcon(self):
        self.nc = h.NetCon(self.soma[0](0.5)._ref_v, None, sec=self.soma[0])
        pc = h.ParallelContext()
        pc.set_gid2node(self._gid, int(pc.id()))
        pc.cell(self._gid, self.nc)
        self.spike_times = h.Vector()
        self.nc.record(self.spike_times)
    def _setup_morphology(self):
        self.soma, self.axon = [], []
        self.dend, self.apic = [], []
        morphology.load('c91662.swc', fileformat='swc',
            cell=self)
    def __repr__(self):
        return 'p[%d]' % self._gid
    def _discretize(self, max_seg_length=20):
        for sec in self.all:
            sec.nseg = 1 + 2 * int(sec.L / max_seg_length)
    def _add_channels(self):
        for sec in self.soma:
            sec.insert('hh')
        for sec in self.all:
            sec.insert('pas')
            for seg in sec:
                seg.pas.g = 0.001

with open('output.json') as f:
    spike_times_by_cell = json.load(f)

def get_m(gid):
    p = Pyramidal(gid)
    # recreate synaptic inputs (here, only one; you may have multiple)
    precell = (gid - 1) % num_cells
    vs = h.VecStim()
    spike_vec = h.Vector(spike_times_by_cell[str(precell)])
    vs.play(spike_vec)
    syn = h.ExpSyn(p.dend[0](0.5))
    nc = h.NetCon(vs, syn)
    nc.delay = 1
    nc.weight[0] = 1
    # setup recording
    t, m = h.Vector(), h.Vector()
    t.record(h._ref_t)
    m.record(p.soma[0](0.5)._ref_m_hh)
    # do run
    pc = h.ParallelContext()
    pc.set_maxstep(10)
    h.v_init = -69
    h.stdinit()
    pc.psolve(100)
    return t, m

t, m = get_m(5)
pyplot.plot(t, m)
pyplot.show()
