from neuron import h, gui
from matplotlib import pyplot
soma = h.Section()
soma.insert('hh')
# current clamps
iclamps = []
for t in [2, 13, 27, 40]:
    i = h.IClamp(0.5, sec=soma)
    i.delay = t # ms
    i.dur = 0.5 # ms
    i.amp = 50
    iclamps.append(i)
# recording
t = h.Vector(); v = h.Vector()
t.record(h._ref_t)
v.record(soma(0.5)._ref_v)
# simulation
h.finitialize()
h.continuerun(49.5)
# compute spike times
st = [t[j] for j in range(len(v) - 1)
      if v[j] <= 0 and v[j + 1] > 0]
print ('spike times:'); print (st)

isis = [next - last for next, last in zip(st[1:], st[:-1])]
print('ISIs:'); print(isis)

# plotting
pyplot.plot(t.as_numpy(), v.as_numpy())
pyplot.show()

