from neuron import h, gui
from matplotlib import pyplot

# morphology and dynamics
soma = h.Section()
soma.insert('hh')

# current clamp
i = h.IClamp(0.5, sec=soma)
i.delay = 2 # ms
i.dur = 0.5 # ms
i.amp = 50

# recording
t = h.Vector()
v = h.Vector()
t.record(h._ref_t)
v.record(soma(0.5)._ref_v)

# simulation
h.finitialize()
h.continuerun(49.5)

# plotting
pyplot.plot(t.as_numpy(), v.as_numpy())
pyplot.show()
