from neuron import h, gui
from PyNeuronToolbox import morphology

class Pyramidal:
    def __init__(self, gid, x, y, z):
        self._gid = gid
        self._setup_morphology()
        self._shift(x, y, z)
    def _setup_morphology(self):
        self.soma, self.axon = [], []
        self.dend, self.apic = [], []
        morphology.load('c91662.swc', fileformat='swc',
            cell=self)
    def _shift(self, x, y, z):
        for sec in self.all:
            n = int(h.n3d(sec=sec))
            xs = [h.x3d(i, sec=sec) for i in range(n)]
            ys = [h.y3d(i, sec=sec) for i in range(n)]
            zs = [h.z3d(i, sec=sec) for i in range(n)]
            ds = [h.diam3d(i, sec=sec) for i in range(n)]
            i = 0
            for a, b, c, d in zip(xs, ys, zs, ds):
                h.pt3dchange(i, a + x, b + y, c + z, d, sec=sec)
                i += 1

    def __repr__(self):
        return 'p[%d]' % self._gid

mypyrs = [Pyramidal(i, i * 100, 0, 0) for i in range(10)]

ps = h.PlotShape()
ps.show(1)