/**
 ** GMALLOC.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "gmalloc.h"

void *_GrMalloc(unsigned int size)
{
	return(malloc(size));
}

void _GrFree(void *ptr)
{
	free(ptr);
}


#ifdef __TURBOC__

void far *_GrFarMalloc(unsigned long size)
{
	return(farmalloc(size));
}

void _GrFarFree(void far *ptr)
{
	farfree(ptr);
}

extern char far *_GrGetTempBuffer(int size)
{
	static char far *tempbuffer;
	static int  tempsize = 0;

	if(size > tempsize) {
	    if(tempsize > 0) _GrFarFree(tempbuffer);
	    size += 20;
	    tempbuffer = _GrFarMalloc(size);
	    if(tempbuffer == (char far *)NULL) {
		tempsize = 0;
		return((char far *)NULL);
	    }
	    tempsize = size;
	}
	return(tempbuffer);
}

#endif

