: "real" cell version of intfire.mod for testing of second order
: correct threshold detection. Note that the membrane potential v now
: plays the role of m.  tau has its normal meaning only when cm=1 and area=100um2
: the voltage should be initialized to 0. A NetCon should watch v(.5)
: and send a -1e9 event with this as target and delay of 0

: dm/dt = (minf - m)/tau
: input event adds w to m
: when m = 1, or event makes m >= 1 cell fires
: minf is calculated so that the natural interval between spikes is invl

NEURON {
	POINT_PROCESS IntRealFire
	RANGE tau, invl
	: m plays the role of voltage
	NONSPECIFIC_CURRENT i
}


PARAMETER {
	tau = 5 (ms)   <1e-9,1e9>
	invl = 10 (ms) <1e-9,1e9>
}

ASSIGNED {
	i (nanoamp)
	v (millivolt)
	minf (millivolt)
	t0(ms)
}

INITIAL {
	minf = 1(millivolt)/(1 - exp(-invl/tau))
}

BREAKPOINT {
	i = (.001)*(v - minf)/tau
}

NET_RECEIVE (w (millivolt)) {
	if (w == -1e9) {
		v = 0
	}else{
		v = v + w
	}
}
