/*
 * Decompiled with CFR 0.152.
 */
package neuron;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Vector;
import neuron.ClassInfo;
import neuron.HocObject;
import neuron.HocVariable;
import neuron.MethodInfo;
import neuron.NrnClassLoader;
import neuron.PWMListener;

public class Neuron {
    static Hashtable classInfo = new Hashtable();
    static Vector classList = new Vector();
    static Vector hoClasses = new Vector();
    private static URLClassLoader ncl;
    static MethodInfo lastMi;
    private static IllegalArgumentException badarg;
    static Vector frames;
    static Vector njwins;

    static native String getHocStringArg(int var0);

    static native double getHocDoubleArg(int var0, int var1);

    static native Object getHocObjectArg(int var0, IllegalArgumentException var1);

    static native int getHocArgType(int var0);

    static native String getHocArgSig();

    static native void hocObjectUnref(long var0);

    static native void java2nrnClass(String var0, int var1, String var2);

    public static native boolean execute(String var0);

    static native long getVarPointer();

    static native double getVal(long var0);

    static native void setVal(long var0, double var2);

    public static int makeHocClass(String string, String string2, String string3) {
        System.out.println("Neuron: makeHocClass called " + string + "  " + string2 + " |" + string3 + "|");
        try {
            Class clazz = null;
            try {
                NrnClassLoader.add((String)string3);
                clazz = NrnClassLoader.load((String)string);
            }
            catch (Throwable throwable) {
                System.out.println(throwable);
                throwable.printStackTrace();
                return 0;
            }
            String string4 = "";
            ClassInfo classInfo = new ClassInfo(clazz, classList.size());
            Method[] methodArray = clazz.getMethods();
            int n = 0;
            while (n < methodArray.length) {
                String string5 = methodArray[n].getName();
                MethodInfo methodInfo = new MethodInfo(methodArray[n]);
                char c = methodInfo.returnType;
                String string6 = null;
                switch (c) {
                    case 'b': 
                    case 'd': 
                    case 'i': 
                    case 'v': {
                        string6 = "d";
                        break;
                    }
                    case 's': {
                        string6 = "s";
                        break;
                    }
                    case 'o': {
                        string6 = "o";
                        break;
                    }
                }
                if (string6 != null) {
                    Class[] classArray = methodArray[n].getParameterTypes();
                    methodInfo.signature = ClassInfo.hocSignature(classArray);
                    if (methodInfo.signature == null) {
                        string6 = null;
                    }
                }
                if (string6 != null) {
                    classInfo.addMethodInfo(methodInfo);
                    if (string4.length() > 0) {
                        string4 = string4 + " ";
                    }
                    string4 = string4 + string6 + " " + string5 + " " + methodInfo.signature;
                }
                ++n;
            }
            Neuron.java2nrnClass(string2, classInfo.id, string4);
            Neuron.classInfo.put(clazz, classInfo);
            classList.addElement(classInfo);
        }
        catch (Throwable throwable) {
            System.out.println("Exception in makeHocClass " + throwable);
            throwable.printStackTrace();
            return 0;
        }
        return 1;
    }

    static int identity(Object object, Object object2) {
        return object == object2 ? 1 : 0;
    }

    static String javaClassName(Object object) {
        return object.getClass().toString();
    }

    static Object constructNoArg(int n) {
        try {
            ClassInfo classInfo = (ClassInfo)classList.elementAt(n);
            if (classInfo.pureStatic) {
                return null;
            }
            Class clazz = classInfo.c;
            Object t = clazz.newInstance();
            return t;
        }
        catch (Exception exception) {
            System.out.println("Exception in constructNoArg " + exception);
            return new Integer(-1);
        }
    }

    static Object[] fillArgs(String string) throws IllegalArgumentException {
        int n = string.length();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            switch (string.charAt(n2)) {
                case 'd': {
                    double d = Neuron.getHocDoubleArg(n2 + 1, 1);
                    if (d == -1.0E98) {
                        throw badarg;
                    }
                    objectArray[n2] = new Double(d);
                    break;
                }
                case 'i': {
                    double d = Neuron.getHocDoubleArg(n2 + 1, 1);
                    if (d == -1.0E98) {
                        throw badarg;
                    }
                    objectArray[n2] = new Integer((int)d);
                    break;
                }
                case 'b': {
                    double d = Neuron.getHocDoubleArg(n2 + 1, 1);
                    if (d == -1.0E98) {
                        throw badarg;
                    }
                    objectArray[n2] = new Boolean(d != 0.0);
                    break;
                }
                case 's': {
                    objectArray[n2] = Neuron.getHocStringArg(n2 + 1);
                    if (objectArray[n2] != null) break;
                    throw badarg;
                }
                case 'o': {
                    objectArray[n2] = Neuron.getHocObjectArg(n2 + 1, badarg);
                    if (objectArray[n2] != badarg) break;
                    throw badarg;
                }
                default: {
                    objectArray[n2] = null;
                    System.out.println("fillArgs: arg " + n2 + " type " + string.charAt(n2) + " not handled yet");
                    throw badarg;
                }
            }
            ++n2;
        }
        return objectArray;
    }

    static Object constructWithArg(int n) {
        try {
            String string;
            int n2;
            ClassInfo classInfo = (ClassInfo)classList.elementAt(n);
            Class clazz = classInfo.c;
            Constructor constructor = null;
            if (classInfo.cons.size() <= 1) {
                n2 = 0;
            } else {
                string = Neuron.getHocArgSig();
                n2 = classInfo.getConstructor(string);
            }
            constructor = (Constructor)classInfo.cons.elementAt(n2);
            string = (String)classInfo.conSig.elementAt(n2);
            int n3 = string.length();
            Object[] objectArray = Neuron.fillArgs(string);
            Object t = constructor.newInstance(objectArray);
            return t;
        }
        catch (Exception exception) {
            System.out.println("Exception in constructWithArg " + exception);
            return new Integer(-1);
        }
    }

    static Object callMethod(Object object, int n, int n2, int n3) {
        try {
            MethodInfo methodInfo;
            ClassInfo classInfo = (ClassInfo)classList.elementAt(n);
            if (classInfo == null) {
                System.out.println("Error: ClassInfo NULL in callMethod");
                return null;
            }
            if (n3 != 0) {
                System.out.println("don't know which of " + (n3 - 1) + " overloaded methods to use");
            }
            if ((methodInfo = classInfo.getMethodInfo(n2)) == null) {
                System.out.println("Error: MethodInfo NULL in callMethod");
                return null;
            }
            Object[] objectArray = Neuron.fillArgs(methodInfo.signature);
            Object object2 = methodInfo.getMethod().invoke(object, objectArray);
            lastMi = methodInfo;
            return object2;
        }
        catch (Exception exception) {
            System.out.println("Exception in callMethod " + exception);
            exception.printStackTrace();
            lastMi = null;
            return new Integer(-1);
        }
    }

    static double invokeDoubleMethod(Object object, int n, int n2, int n3) {
        Object object2 = Neuron.callMethod(object, n, n2, n3);
        if (lastMi == null) {
            return -1.0E98;
        }
        char c = Neuron.lastMi.returnType;
        switch (c) {
            case 'd': {
                return (Double)object2;
            }
            case 'b': {
                return (Boolean)object2 != false ? 1.0 : 0.0;
            }
            case 'i': {
                return ((Integer)object2).doubleValue();
            }
            case 'v': {
                return 1.0;
            }
        }
        return -1.0E98;
    }

    static String invokeCharsMethod(Object object, int n, int n2, int n3) {
        String string = null;
        try {
            string = new String((char[])Neuron.callMethod(object, n, n2, n3));
            if (lastMi == null) {
                return null;
            }
        }
        catch (Exception exception) {
            System.out.println("invokeCharsMethod exception " + exception);
            string = null;
        }
        return string;
    }

    static Object invokeObjectMethod(Object object, int n, int n2, int n3) throws Exception {
        Object object2 = Neuron.callMethod(object, n, n2, n3);
        if (lastMi == null) {
            throw new Exception();
        }
        return object2;
    }

    static int getObjectType(Object object) {
        try {
            Class<?> clazz = object.getClass();
            ClassInfo classInfo = (ClassInfo)Neuron.classInfo.get(clazz);
            if (classInfo == null) {
                return -((HocObject)object).id - 2;
            }
            return classInfo.id;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    static Object encapsulateHocObject(long l, int n) {
        HocObject hocObject = null;
        try {
            Class clazz = (Class)hoClasses.elementAt(n);
            hocObject = (HocObject)clazz.newInstance();
            hocObject.hocObjectCast = l;
            hocObject.id = n;
        }
        catch (Exception exception) {
            System.out.println("encapsulateHocObject failed " + exception);
            exception.printStackTrace();
        }
        return hocObject;
    }

    public static double dMethod(String string, Object[] objectArray) {
        HocObject.pushArgs(objectArray);
        return Neuron.hDoubleMethod(string, objectArray.length);
    }

    static native long vectorNew(int var0);

    static native int vectorSize(long var0);

    static native void vectorSet(long var0, int var2, double var3);

    static native double vectorGet(long var0, int var2);

    static native void vectorToHoc(long var0, double[] var2, int var3);

    static native double[] vectorFromHoc(long var0);

    static native long cppPointer(long var0);

    static native String hocObjectName(long var0);

    static native long getNewHObject(String var0, int var1);

    static native double hDoubleMethod(long var0, long var2, int var4);

    static native double hDoubleMethod(String var0, int var1);

    static native String hCharsMethod(long var0, long var2, int var4);

    static native Object hObjectMethod(long var0, long var2, int var4);

    static native void pushArgD(double var0);

    static native void pushArgS(String var0);

    static native void pushArgO(Object var0, int var1);

    static native long methodID(long var0, String var2);

    public static double dGet(String string) {
        return new HocVariable(string).getVal();
    }

    public static native String sGet(String var0);

    public static native Object oGet(String var0);

    public static void dSet(String string, double d) {
        new HocVariable(string).setVal(d);
    }

    public static void sSet(String string, String string2) {
        Neuron.execute(string + "=\"" + string2 + "\"");
    }

    public static void oSet(String string, Object object) {
        Neuron.hSetObjectField(string, object, Neuron.getObjectType(object));
    }

    static native String hGetStringField(long var0, String var2);

    static native Object hGetObjectField(long var0, String var2);

    static native void hSetObjectField(long var0, String var2, Object var3, int var4);

    static native void hSetObjectField(String var0, Object var1, int var2);

    public static void windowListen(Frame frame, Object object) {
        if (frames.contains(frame)) {
            return;
        }
        long l = Neuron.pwmListen(frame.getTitle(), object, Neuron.getObjectType(object));
        PWMListener pWMListener = new PWMListener(frame, l);
        frame.addWindowListener(pWMListener);
        frame.addComponentListener(pWMListener);
        frames.addElement(frame);
        njwins.addElement(new Long(l));
    }

    static native long pwmListen(String var0, Object var1, int var2);

    static native void pwmEvent(long var0, int var2, int var3, int var4, int var5, int var6);

    static int setwin(long l, int n, int n2, int n3) {
        try {
            int n4 = njwins.size();
            int n5 = 0;
            while (n5 < n4) {
                long l2 = (Long)njwins.elementAt(n5);
                if (l2 == l) {
                    Frame frame = (Frame)frames.elementAt(n5);
                    switch (n) {
                        case 1: {
                            frame.show();
                            break;
                        }
                        case 2: {
                            frame.hide();
                            break;
                        }
                        case 3: {
                            ((Component)frame).setLocation(new Point(n2, n3));
                            break;
                        }
                        case 4: {
                            ((Component)frame).setSize(n2, n3);
                        }
                    }
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
        return 0;
    }

    static {
        try {
            hoClasses.addElement(NrnClassLoader.load((String)"neuron.HocObject"));
            hoClasses.addElement(NrnClassLoader.load((String)"neuron.HocVector"));
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
        badarg = new IllegalArgumentException();
        frames = new Vector();
        njwins = new Vector();
    }
}

