/*****************************************************************************
 *                                                                           *
 * Copyright (c) 2003-2004 Intel Corporation.                                *
 * All rights reserved.                                                      *
 *                                                                           *
 *****************************************************************************

This code is covered by the Community Source License (CPL), version
1.0 as published by IBM and reproduced in the file "license.txt" in the
"license" subdirectory. Redistribution in source and binary form, with
or without modification, is permitted ONLY within the regulations
contained in above mentioned license.

Use of the name and trademark "Intel(R) MPI Benchmarks" is allowed ONLY
within the regulations of the "License for Use of "Intel(R) MPI
Benchmarks" Name and Trademark" as reproduced in the file
"use-of-trademark-license.txt" in the "license" subdirectory. 

THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR
CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT
LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is
solely responsible for determining the appropriateness of using and
distributing the Program and assumes all risks associated with its
exercise of rights under this Agreement, including but not limited to
the risks and costs of program errors, compliance with applicable
laws, damage to or loss of data, programs or equipment, and
unavailability or interruption of operations.

EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER RECIPIENT NOR
ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING
WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OR
DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED
HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. 

EXPORT LAWS: THIS LICENSE ADDS NO RESTRICTIONS TO THE EXPORT LAWS OF
YOUR JURISDICTION. It is licensee's responsibility to comply with any
export regulations applicable in licensee's jurisdiction. Under
CURRENT U.S. export regulations this software is eligible for export
from the U.S. and can be downloaded by or otherwise exported or
reexported worldwide EXCEPT to U.S.  embargoed destinations which
include Cuba, Iraq, Libya, North Korea, Iran, Syria, Sudan,
Afghanistan and any other country to which the U.S. has embargoed
goods and services.

 ***************************************************************************

For more documentation than found here, see

[1] doc/ReadMe_IMB.txt 

[2] Intel (R) MPI Benchmarks
    Users Guide and Methodology Description
    In 
    doc/IMB_ug.pdf
    
 File: IMB.c 

 Implemented functions: 

 main;

 ***************************************************************************/

#include "mpi.h"

#include "IMB_declare.h"
#include "IMB_benchmark.h"

#include "IMB_prototypes.h"


/**********************************************************************/



int main(int argc, char **argv)
/*



Input variables: 

-argc                 (type int)
                      Number of command line arguments
                      

-argv                 (type char **)                      
                      List of command line arguments
                      


Return value          (type int)                      
                      0 always
                      


*/
{
struct comm_info C_INFO;   /* BASIC SETTINGS STRUCTURE    */
struct Bench* BList;       /* List of Benchmarks          */

struct Bench* Bmark;

#ifdef CHECK
int NFAIL, NSUCCESS;
#endif

char *p;
int  i,j,iter,imod,ierr;
int  NP,NP_min;
int  do_it  ; 

int   header;              
int     size;             
int   MAXMSG;
int x_sample,n_sample;            
MODES BMODE;            
double  time[MAX_TIMINGS]; 

Type_Size unit_size;      

if( (ierr=MPI_Init(&argc,&argv))!=MPI_SUCCESS) IMB_err_hand(1, ierr);

IMB_set_default(&C_INFO);

IMB_init_pointers(&C_INFO);

if( IMB_basic_input(&C_INFO,&BList,&argc,&argv,&NP_min)<0 )
{
IMB_free_all(&C_INFO, &BList);
MPI_Finalize();
return 1;
}

IMB_show_selections(&C_INFO,BList);

/* LOOP OVER INDIVIDUAL BENCHMARKS */
j=0;
while( (p=BList[j].name) )
  {
 Bmark = BList+j;
 if( Bmark->RUN_MODES[0].type != BTYPE_INVALID )
  {

    NP=max(1,min(C_INFO.w_num_procs,NP_min));
    if( Bmark->RUN_MODES[0].type == SingleTransfer )
     {
#ifndef MPIIO
      NP = (min(2,C_INFO.w_num_procs));
#else
      NP = 1;
#endif
     }

    do_it = 1;
/* LOOP OVER PROCESS NUMBERS */
    while ( do_it )       
      {
        if ( IMB_valid(&C_INFO,Bmark,NP) )
        {

	if(IMB_init_communicator(&C_INFO,NP)!=0) IMB_err_hand(0,-1);

#ifdef MPIIO
	if(IMB_init_file(&C_INFO,Bmark,NP)!=0) IMB_err_hand(0,-1);
#endif

	/* MINIMAL OUTPUT IF UNIT IS GIVEN */
	if (C_INFO.w_rank==0)
	  {
	    if(unit != stdout) 
	      printf
              ("# Running %s; see file \"%s\" for results\n",p,OUTPUT_FILENAME);
	  };
	header=1;

	MAXMSG=1<<MAXMSGLOG;

#ifdef EXT
        MPI_Type_size(C_INFO.red_data_type,&unit_size);
#else
        
	if (Bmark->reduction)
               MPI_Type_size(C_INFO.red_data_type,&unit_size);
	else   MPI_Type_size(C_INFO.s_data_type,&unit_size);
#endif

	MAXMSG=(1<<MAXMSGLOG)/unit_size* unit_size;
	

        for( imod=0; imod < Bmark->N_Modes; imod++ )
        {

        BMODE=&Bmark->RUN_MODES[imod];

        x_sample = BMODE->AGGREGATE ? MSGSPERSAMPLE : MSGS_NONAGGR;
/* July 2002 fix V2.2.1: */
#if (defined EXT || defined MPIIO)
        if( Bmark->access==no ) x_sample=MSGS_NONAGGR;
#endif

	header=header | (imod > 0);
	
        iter=0;
	size =0;


/* LOOP OVER MESSAGE LENGTHS */
        while ( (C_INFO.n_lens==0&&size < MAXMSG)||
                (C_INFO.n_lens>0 &&iter < C_INFO.n_lens))
	      {  
		if( iter == 0 ) 
		  {
                    if( C_INFO.n_lens>0 ) size=C_INFO.msglen[0];
		    else                  size     = 0;
		  }
		else if ( iter == 1 ) 
		  {  
                    if( C_INFO.n_lens>0 ) size=C_INFO.msglen[1];
		    else 
		    size = ((1<<MINMSGLOG) + unit_size - 1)/unit_size*unit_size;
#ifdef EXT
                    if( size < asize ) size = asize;
#endif
		  }
		else
		  { 
                    if( C_INFO.n_lens>0 ) size=C_INFO.msglen[iter];
		    else                  size     = min(MAXMSG,size+size);
		  }

                if( size> MAXMSG )
                 {
                 if( C_INFO.w_rank==0 )
                 fprintf(unit,"Attention, msg size %d truncated to %d\n",
                               size,MAXMSG);
                 size = MAXMSG;
                 } 

                size = (size+unit_size-1)/unit_size*unit_size;

                if ( size>0 )
                n_sample =max(1,min(OVERALL_VOL/size,x_sample));
                else n_sample = x_sample ;


                if( Bmark->RUN_MODES[0].type == Sync ) 
                   {
                    size=MAXMSG; iter = C_INFO.n_lens;
                   }

                for(i=0; i<MAX_TIMINGS; i++) time[i] = 0.;

                IMB_init_buffers(&C_INFO, Bmark, size);

	        IMB_init_transfer(&C_INFO, Bmark, size);

		IMB_warm_up  (&C_INFO,Bmark,iter);                    

		Bmark->Benchmark(&C_INFO,size,n_sample,BMODE,time);

                /* Synchronization, in particular for idle processes
                   which have to wait in a well defined manner */
                MPI_Barrier(MPI_COMM_WORLD);
                     
	  	IMB_output   (&C_INFO,Bmark,BMODE,header,size,n_sample,time);

                IMB_close_transfer(&C_INFO, Bmark, size);

                CHK_BRK;
		
		header = 0;
		iter++;
	      }

        if( !Bmark->success && C_INFO.w_rank == 0 )
          fprintf(unit,"\n\n!!! Benchmark unsuccessful !!!\n\n");

        CHK_BRK;
        }

        CHK_BRK;
        }

	/* CALCULATE THE NUMBER OF PROCESSES FOR NEXT STEP */
	if( NP == C_INFO.w_num_procs  ) {do_it=0;}
	else
	  {
	    NP=min(NP+NP,C_INFO.w_num_procs);
	  }	  
#ifdef MPIIO
          if( Bmark->RUN_MODES[0].type == SingleTransfer ) do_it = 0;
#endif
	
      CHK_BRK;
      }

  }
  CHK_BRK;
  j++;
  }
#ifdef CHECK

if( C_INFO.w_rank == 0 )
{
j=0;
NFAIL=0;
NSUCCESS=0;
while( (p=BList[j].name) )
{
 Bmark = BList+j;
 if( Bmark->RUN_MODES[0].type != BTYPE_INVALID )
  {
   Bmark = BList+j;
   if( !Bmark->success ) NFAIL ++;
   else                  NSUCCESS++;
  } 
j++;
}
    
if( NFAIL == 0 && NSUCCESS>0 )
{
fprintf(unit,"\n\n!!!!  ALL BENCHMARKS SUCCESSFUL !!!! \n\n");
}
else if( NSUCCESS>0 )
{
if( NFAIL == 1 )
fprintf(unit,"\n\n!!!!  %d  BENCHMARK FAILED     !!!! \n\n",NFAIL);
else
fprintf(unit,"\n\n!!!!  %d  BENCHMARKS FAILED     !!!! \n\n",NFAIL);

j=0;
while( (p=BList[j].name) )
{
 Bmark = BList+j;
 if( Bmark->RUN_MODES[0].type != BTYPE_INVALID )
  {
   if( Bmark->success ) fprintf(unit,"%s    : Successful\n",p);
   else                 fprintf(unit,"%s    : FAILED !! \n",p);
  } 
j++;
}
}
}

#endif

IMB_end_msg(&C_INFO);

IMB_free_all(&C_INFO, &BList);
MPI_Finalize();

return 0;
}
